//Waveform synthesis of x(t)=2u(t)-3u(t-2)+2u(t-4)
//Windows 10
//Scilab 6.1.0
clear
clc
//Plot of x(t)
f=input('Enter the sampling frequency:')
T=1/f;
L=input('Enter the lower bound for the time axis of x(t):')
U=input('Enter the upper bound for the time axis of x(t):')
t=L-1:T:U+2;
x=zeros(1,length(t));
y=x;
x(find(t==0):find(t==2))=2;
x(find(t==2):find(t==4))=-3;
x(find(t==4):length(t))=2;
//Synthesis
z=find(diff(x)==2);
y(z(1)+1:length(y))=2;
subplot(4,1,1)
xset("thickness",3)
plot2d2(t,x,rect=[L-1 min(x)-1 U+2 max(x)+1])
xtitle("x(t)","time","Amplitude")
legend('2u(t)-3u(t-2)+2u(t-4) with f=1000',3)
xstring(t(find(t==1)),x(find(t==1)),["2"])
xstring(t(find(t==3)),x(find(t==3)),["-3"])
xstring(t(find(t==5)),x(find(t==5)),["2"])
subplot(4,1,2)
xset("thickness",3)
plot2d2(t,y,rect=[L-1 min(y) U+2 max(y)+1])
xtitle("","time","Amplitude")
legend('The First Constituent Step Function',2)
xstring(t(find(t==1)),x(find(t==1)),["2"])
y=y-y;
z=find(diff(x)==-5);
y(z(1)+1:length(y))=-5;
subplot(4,1,3)
xset("thickness",3)
plot2d2(t,y,rect=[L-1 min(y)-1 U+2 max(y)])
xtitle("","time","Amplitude")
legend('The Second Constituent Step Function')
xstring(t(find(t==2)),x(find(t==2)),["-5"])
y=y-y;
z=find(diff(x)==5);
y(z(1)+1:length(y))=5;
subplot(4,1,4)
xset("thickness",3)
plot2d2(t,y,rect=[L-1 min(y) U+2 max(y)+1])
xtitle("","time","Amplitude")
legend('The Third Constituent Step Function',2)
xstring(t(find(t==4)),x(find(t==4)),["5"])

//output test case
//sampling frequency 1000
//lower bound for the time axis of x(t) 0
//upper bound for the time axis of x(t) 5
